--[[----------------------------------------------------------------------------
	Copyright 2008 João Liborio Cardoso
	All rights reserved
	
	Bongos Reputation is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
	Bongos Reputation is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License (<http://www.gnu.org/licenses/>) for more details.
---------------------------------------------------------------------------]]--

local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-XP')
local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local Reputation = Bongos:NewModule('Reputation')
local XP = Bongos:GetModule('XP')


--[[ Startup ]]--

function Reputation:Load()
	local defaults = {
		alwaysShowText = true,
		textX = 0,
		textY = 0,
		point = 'TOP',
		width = 0.75,
		height = 14,
		y = -46,
		x = 0,
	}

	local bar, isNew = Bongos.Bar:Create('reputation', defaults, 'MEDIUM')
	if isNew then
		setmetatable(self, {__index = XP})
		self.LoadBar(bar)
		self.HookBar(bar)
	end
	
	bar.xp:ToggleText(bar.sets.alwaysShowText)
	bar.xp:UpdateOrientation()
	bar.xp:UpdateWatch()

	self.bar = bar
end

function Reputation:HookBar()
	self.xp:RegisterEvent('UPDATE_FACTION', 'UpdateWatch')
	self.xp:SetScript('OnMouseUp', nil)
	self.xp:SetScript('OnShow', nil)
	self.xp:SetScript('OnHide', nil)

	for k,v in pairs(Reputation) do
		self[k] = v
		self.xp[k] = v
	end
end


--[[ Disable Experience ]]--

function Reputation:UpdateWatch()
	if GetWatchedFactionInfo() then
		self:WatchReputation()
		self:Show()
	else
		self:Hide()
	end
end


--[[ Menu ]]--

function Reputation:CreateMenu()
	local menu = Bongos.Menu:Create(self.id)
	local panel = menu:AddLayoutPanel()

	self:CreateVerticalButton(panel)
	self:CreateHeightSlider(panel)
	self:CreateWidthSlider(panel)
	
	local panel = menu:AddPanel(L.Text)
	
	self:CreateAlwaysShowTextButton(panel)
	self:CreateTextPositionSlider(panel, L.HorizontalPosition, 'textX')
	self:CreateTextPositionSlider(panel, L.VerticalPosition, 'textY')

	return menu
end